/*
 * Decompiled with CFR 0.152.
 */
package tw.com.prolific.driver.pl2303g;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Build;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PL2303GDriver<UsbConfiguration> {
    private boolean e = false;
    private static final boolean f = false;
    private static final boolean g = false;
    private static final boolean h = false;
    private static String i = "1.0.0.0";
    public static final int BAUD0 = 0;
    public static final int BAUD75 = 75;
    public static final int BAUD150 = 150;
    public static final int BAUD300 = 300;
    public static final int BAUD600 = 600;
    public static final int BAUD1200 = 1200;
    public static final int BAUD1800 = 1800;
    public static final int BAUD2400 = 2400;
    public static final int BAUD4800 = 4800;
    public static final int BAUD9600 = 9600;
    public static final int BAUD14400 = 14400;
    public static final int BAUD19200 = 19200;
    public static final int BAUD38400 = 38400;
    public static final int BAUD57600 = 57600;
    public static final int BAUD115200 = 115200;
    public static final int BAUD230400 = 230400;
    public static final int BAUD460800 = 460800;
    public static final int BAUD614400 = 614400;
    public static final int BAUD921600 = 921600;
    public static final int BAUD1228800 = 1228800;
    public static final int BAUD2457600 = 2457600;
    public static final int BAUD3000000 = 3000000;
    public static final int BAUD6000000 = 6000000;
    public static final int BAUD12000000 = 12000000;
    public static final int PL2303G_DCD_ON = 1;
    public static final int PL2303G_DSR_ON = 2;
    public static final int PL2303G_RI_ON = 8;
    public static final int PL2303G_CTS_ON = 128;
    private byte[] j = new byte[7];
    static final int a = 11;
    static final int b = 12;
    private static final int k = 33;
    private static final int l = 32;
    private static final int m = 33;
    private static final int n = 35;
    private static final int o = 0;
    private static final int p = 161;
    private static final int q = 33;
    private static final int r = 64;
    private static final int s = 192;
    private static final int t = 33;
    private static final int u = 34;
    private static final int v = 128;
    private static final int w = 129;
    private static final int x = 130;
    private static final int y = 130;
    private static final int z = 131;
    private static final int A = 0;
    private static final int B = 1;
    private static final int C = 2;
    private static final int D = 2056;
    private static final int E = 2313;
    private int F = 0;
    private byte G = 0;
    private static final int H = 1;
    private static final int I = 2;
    private static final int J = 32;
    public static final int PL_MAX_INTERFACE_NUM = 4;
    private final int K = 64;
    private UsbManager L;
    private UsbDevice M;
    private UsbDeviceConnection N;
    private UsbInterface O;
    private UsbEndpoint P;
    private UsbEndpoint Q;
    private UsbEndpoint R;
    public static final int READBUF_SIZE = 4096;
    public static final int WRITEBUF_SIZE = 4096;
    private static final boolean S = false;
    private static final boolean T = false;
    private int U;
    private int V;
    byte[] c = new byte[4096];
    private int W;
    private int X;
    private int Y;
    private ArrayBlockingQueue<Integer> Z = new ArrayBlockingQueue(4096, true);
    public static Object ReadQueueLock = new Object();
    private a aa;
    private boolean ab;
    private int ac = 0;
    private int ad = 0;
    private boolean ae = false;
    private boolean af = false;
    private String ag;
    private ArrayList<String> ah = new ArrayList();
    private int ai;
    Context d;
    private int aj = 0;
    private final int ak = 2;
    private final int al = 3;
    private final int am = 4;
    private final int an = 5;
    private final int ao = 6;
    private final int ap = 7;
    private final int aq = 8;
    private final int ar = 9;
    private final int as = 10;
    private boolean at;
    private boolean au;
    private boolean av;
    private FlowControl aw;
    private boolean ax;
    private final boolean ay = true;
    private final boolean az = false;
    private final int aA = 17;
    private final int aB = 19;
    public final String PLUART_MESSAGE = "tw.PL2303USBMessage";
    public final String PLUART_DETACHED = "USB.Detached";
    public final int PLDETACHED_VALUE = 255;
    private int aC;
    private int aD;
    private int aE;
    private int aF;
    private int aG;
    private int aH;
    private int aI;
    private int aJ;
    private boolean aK = false;
    private boolean aL = false;
    private int aM = 0;
    private int aN = 0;
    private final BroadcastReceiver aO = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String string = intent.getAction();
            UsbDevice usbDevice = (UsbDevice)intent.getParcelableExtra("device");
            if (!"android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(string)) {
                if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(string)) {
                    String string2 = usbDevice.getDeviceName();
                    if (PL2303GDriver.this.M != null && PL2303GDriver.this.M.equals((Object)string2)) {
                        Intent intent2 = new Intent("tw.PL2303USBMessage");
                        intent2.putExtra("USB.Detached", String.valueOf(255));
                        PL2303GDriver.this.d.sendBroadcast(intent2);
                        PL2303GDriver.this.end();
                    }
                } else if (string.equals(PL2303GDriver.this.ag)) {
                    1 var5_6 = this;
                    synchronized (var5_6) {
                        if (intent.getBooleanExtra("permission", false) && usbDevice != null) {
                            int n = 0;
                            while (n < PL2303GDriver.this.ai) {
                                if (String.format("%04X:%04X", usbDevice.getVendorId(), usbDevice.getProductId()).equals(PL2303GDriver.this.ah.get(n))) {
                                    PL2303GDriver.this.b(usbDevice);
                                    return;
                                }
                                ++n;
                            }
                        }
                    }
                }
            }
        }
    };
    public static UsbDevice sDevice = null;
    private Runnable aP = new Runnable(){

        public void run() {
            UsbDevice usbDevice = sDevice;
            if (!PL2303GDriver.this.isConnected()) {
                PL2303GDriver.this.a(usbDevice);
                PL2303GDriver.this.at = true;
            }
        }
    };
    private static /* synthetic */ int[] aQ;
    private static /* synthetic */ int[] aR;
    private static /* synthetic */ int[] aS;
    private static /* synthetic */ int[] aT;
    private static /* synthetic */ int[] aU;

    private void a(UsbManager usbManager, Context context, String string, boolean bl) {
        this.L = usbManager;
        this.M = null;
        this.P = null;
        this.Q = null;
        this.R = null;
        this.U = 0;
        this.V = 0;
        this.at = false;
        this.ab = false;
        this.au = false;
        this.d = context;
        this.av = bl;
        this.ag = string;
        this.ax = true;
        this.aw = FlowControl.OFF;
        this.b("067B:23A3");
        this.b("067B:23B3");
        this.b("067B:23C3");
        this.b("067B:23D3");
        this.b("067B:23E3");
        this.b("067B:2320");
        this.b("067B:2321");
        this.b("067B:2322");
        this.b("067B:2323");
        this.ai = this.ah.size();
        this.aC = 0;
        this.aD = 15;
        this.aE = 3;
        this.aF = 0;
        this.aG = 0;
        this.aH = 0;
        this.aI = 0;
        this.aJ = 0;
        this.W = 100;
        this.X = 100;
        this.Y = 100;
    }

    public PL2303GDriver(UsbManager manager, Context mContext, String sAppName) {
        this.a(manager, mContext, sAppName, true);
    }

    public PL2303GDriver(UsbManager manager, Context mContext, String sAppName, boolean bWithQueue) {
        this.a(manager, mContext, sAppName, bWithQueue);
    }

    private void a(UsbDevice usbDevice) {
        UsbInterface usbInterface;
        boolean bl;
        block13: {
            UsbDeviceConnection usbDeviceConnection;
            int n;
            int n2;
            block12: {
                int n3 = 0;
                bl = false;
                n2 = 0;
                if (this.N != null) {
                    if (this.O != null) {
                        this.N.releaseInterface(this.O);
                        this.O = null;
                    }
                    this.N.close();
                    this.M = null;
                    this.N = null;
                }
                if (usbDevice == null) {
                    return;
                }
                n = usbDevice.getInterfaceCount();
                usbDeviceConnection = this.L.openDevice(usbDevice);
                if (1 != n) break block12;
                int n4 = n - 1;
                usbInterface = usbDevice.getInterface(n4);
                if (255 != usbInterface.getInterfaceClass() || 3 != usbInterface.getEndpointCount()) break block13;
                bl = true;
                n3 = n4;
                if (usbInterface == null || usbDeviceConnection == null) break block13;
                if (usbDeviceConnection.claimInterface(usbInterface, true)) {
                    this.M = usbDevice;
                    this.N = usbDeviceConnection;
                    this.O = usbInterface;
                    if (this.a(this.O)) {
                        return;
                    }
                } else {
                    usbDeviceConnection.close();
                }
                break block13;
            }
            n = 2;
            int n5 = 0;
            while (n5 < n) {
                usbInterface = usbDevice.getInterface(n5);
                if (usbDeviceConnection.claimInterface(usbInterface, true)) {
                    n2 = usbInterface.getEndpointCount() + n2;
                    this.a(usbInterface);
                    if (3 == n2) {
                        this.M = usbDevice;
                        this.N = usbDeviceConnection;
                        this.O = usbInterface;
                        bl = true;
                        if (this.M.getDeviceClass() == 239 && this.M.getDeviceSubclass() == 2 && this.M.getDeviceProtocol() == 1) {
                            this.aL = true;
                        }
                        return;
                    }
                } else {
                    usbDeviceConnection.close();
                }
                ++n5;
            }
        }
        if (!bl) {
            usbInterface = new Intent("tw.PL2303USBMessage");
            usbInterface.putExtra("USB.Detached", String.valueOf(255));
            this.d.sendBroadcast((Intent)usbInterface);
            this.end();
            return;
        }
    }

    boolean a(String string) {
        String string2 = "";
        boolean bl = true;
        if (Build.VERSION.SDK_INT >= 21) {
            return true;
        }
        try {
            String string3 = "toolbox ls " + string;
            Process process = Runtime.getRuntime().exec(string3);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string4 = null;
            while ((string4 = bufferedReader.readLine()) != null) {
                string2 = String.valueOf(string2) + string4;
            }
            if (string.compareTo(string2) != 0) {
                bl = false;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private boolean b(String string) {
        this.ah.add(string);
        this.ai = this.ah.size();
        return true;
    }

    public boolean enumerate() {
        this.L = (UsbManager)this.d.getSystemService("usb");
        HashMap hashMap = this.L.getDeviceList();
        Iterator iterator = hashMap.values().iterator();
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.d, (int)0, (Intent)new Intent(this.ag), (int)0);
        while (iterator.hasNext()) {
            UsbDevice usbDevice = (UsbDevice)iterator.next();
            int n = 0;
            while (n < this.ai) {
                if (String.format("%04X:%04X", usbDevice.getVendorId(), usbDevice.getProductId()).equals(this.ah.get(n)) && this.a(usbDevice.getDeviceName())) {
                    IntentFilter intentFilter = new IntentFilter(this.ag);
                    intentFilter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
                    this.d.registerReceiver(this.aO, intentFilter);
                    if (!this.L.hasPermission(usbDevice)) {
                        this.L.requestPermission(usbDevice, pendingIntent);
                    } else {
                        this.b(usbDevice);
                        if (String.format("%04X:%04X", usbDevice.getVendorId(), usbDevice.getProductId()).equals("067B:2551") || String.format("%04X:%04X", usbDevice.getVendorId(), usbDevice.getProductId()).equals("067B:2503") || String.format("%04X:%04X", usbDevice.getVendorId(), usbDevice.getProductId()).equals("067B:A100")) {
                            this.au = true;
                        }
                        return true;
                    }
                }
                ++n;
            }
        }
        return false;
    }

    private void b(UsbDevice usbDevice) {
        sDevice = usbDevice;
        new Thread(this.aP).start();
    }

    private boolean f() {
        int n = 0;
        if (!this.at) {
            return false;
        }
        if (this.M == null) {
            return false;
        }
        this.aj = 10;
        n = this.b(8, 254);
        if (n < 0) {
            return false;
        }
        this.aa = this.av ? new a() : null;
        return true;
    }

    public boolean InitByDefualtValue() {
        if (!this.f()) {
            return false;
        }
        if (this.av) {
            this.g();
        }
        return true;
    }

    public boolean InitByBaudRate(BaudRate R) {
        if (!this.f()) {
            return false;
        }
        int n = 0;
        try {
            n = this.setup(R, DataBits.D8, StopBits.S1, Parity.NONE, FlowControl.OFF);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (n < 0) {
            return false;
        }
        if (this.av) {
            this.g();
        }
        return true;
    }

    public boolean InitByBaudRate(BaudRate R, int TimeoutConstant) {
        if (!this.f()) {
            return false;
        }
        int n = 0;
        try {
            n = this.setup(R, DataBits.D8, StopBits.S1, Parity.NONE, FlowControl.OFF);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (n < 0) {
            return false;
        }
        if (!this.PL2303Device_SetCommTimeouts(TimeoutConstant)) {
            return false;
        }
        if (this.av) {
            this.g();
        }
        return true;
    }

    public boolean InitByPortSetting(BaudRate R, DataBits D, StopBits S, Parity P, FlowControl F) {
        if (!this.f()) {
            return false;
        }
        int n = 0;
        try {
            n = this.setup(R, D, S, P, F);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (n < 0) {
            return false;
        }
        if (this.av) {
            this.g();
        }
        return true;
    }

    public void end() {
        if (this.M != null) {
            if (this.av) {
                this.h();
            }
            this.au = false;
            this.d.unregisterReceiver(this.aO);
            this.a((UsbDevice)null);
        }
    }

    public boolean isConnected() {
        return this.M != null && this.P != null && this.Q != null;
    }

    private boolean a(UsbInterface usbInterface) {
        if (usbInterface == null) {
            return false;
        }
        int n = 0;
        while (n < usbInterface.getEndpointCount()) {
            if (usbInterface.getEndpoint(n).getType() == 2) {
                if (usbInterface.getEndpoint(n).getDirection() == 128) {
                    this.P = usbInterface.getEndpoint(n);
                } else {
                    this.Q = usbInterface.getEndpoint(n);
                }
            } else if (usbInterface.getEndpoint(n).getType() == 3 && usbInterface.getEndpoint(n).getDirection() == 128) {
                this.R = usbInterface.getEndpoint(n);
            }
            ++n;
        }
        return true;
    }

    private void g() {
        if (!this.ab) {
            this.aa.start();
            this.aa.setPriority(10);
            this.ab = this.aa.isAlive();
        }
    }

    private void h() {
        if (this.ab && this.aa != null) {
            this.aa.b();
            this.ab = this.aa.isAlive();
            this.aa = null;
        }
    }

    private void a(BaudRate baudRate) {
        int[] nArray = new int[]{3, 5, 10, 25, 100, 200};
        int n = nArray[3];
        switch (PL2303GDriver.a()[baudRate.ordinal()]) {
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n = nArray[0];
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n = nArray[1];
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n = nArray[2];
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n = nArray[3];
                break;
            }
            case 4: 
            case 5: {
                n = nArray[4];
                break;
            }
            case 2: 
            case 3: {
                n = nArray[5];
                break;
            }
            case 1: {
                n = 10000;
                break;
            }
            default: {
                return;
            }
        }
        if (this.aa != null) {
            this.aa.b(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buf) {
        int n = 0;
        int n2 = buf.length;
        if (n2 == 0) {
            return 0;
        }
        if (n2 > 4096) {
            buf = new byte[4096];
        }
        if (this.av) {
            Object object = ReadQueueLock;
            synchronized (object) {
                int n3 = this.Z.size();
                if (n3 > 0) {
                    n = n2 >= n3 ? n3 : n2;
                    int n4 = 0;
                    while (n4 < n) {
                        Integer n5 = this.Z.poll();
                        if (n5 != null) {
                            buf[n4] = (byte)(n5 & 0xFF);
                            ++n4;
                            continue;
                        }
                        break;
                    }
                } else {
                    n = 0;
                }
            }
        }
        int n6 = this.a(buf, n2);
        if (n6 > 0) {
            n = n2 >= n6 ? n6 : n2;
        }
        return n;
    }

    private int a(byte[] byArray, int n) {
        int n2;
        if (byArray.length == 0 || n == 0) {
            return 0;
        }
        if (this.N == null) {
            this.aa.b();
            return -1;
        }
        if (this.V > 0 && n <= this.V) {
            if (!this.e) {
                System.arraycopy(this.c, this.U, byArray, 0, n);
            } else {
                int n3 = 0;
                while (n3 < n) {
                    byArray[n3] = this.c[this.U++];
                    ++this.ac;
                    while ((this.ac - 1) % 10 != Byte.valueOf(byArray[n3]) - 48) {
                        ++this.ac;
                    }
                    ++n3;
                }
                this.ad += n;
                this.ae = true;
            }
            this.V -= n;
            return n;
        }
        int n4 = 0;
        int n5 = n;
        if (this.V > 0) {
            n5 -= this.V;
            System.arraycopy(this.c, this.U, byArray, n4, this.V);
        }
        if ((n2 = this.N.bulkTransfer(this.P, this.c, this.c.length, this.W)) < 0) {
            return n2;
        }
        if (n2 == 0) {
            return 0;
        }
        int n6 = n2 / 64;
        int n7 = n2 % 64;
        if (n7 > 0) {
            ++n6;
        }
        this.V = n2;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n6) {
            int n10 = n9 * 64;
            int n11 = 0;
            while (n11 < 64) {
                this.c[n8++] = this.c[n10 + n11];
                ++n11;
            }
            ++n9;
        }
        this.U = 0;
        while (this.V > 0 && n5 > 0) {
            byArray[n4++] = this.c[this.U++];
            if (this.e) {
                ++this.ac;
                while ((this.ac - 1) % 10 != Byte.valueOf(byArray[n4 - 1]) - 48) {
                    ++this.ac;
                }
            }
            --this.V;
            --n5;
        }
        if (this.e) {
            if (n4 > 0) {
                this.ad += n4;
                this.ae = true;
            }
            if (this.ae) {
                this.ae = false;
            }
        }
        return n4;
    }

    public int write(byte[] buf) {
        return this.write(buf, buf.length);
    }

    /*
     * Unable to fully structure code
     */
    public int write(byte[] buf, int wlength) {
        var3_3 = 0;
        var5_4 = new byte[4096];
        if (this.N == null) {
            var5_4 = null;
            return -1;
        }
        if (FlowControl.XONXOFF != this.aw || this.ax) ** GOTO lbl16
        return 0;
lbl-1000:
        // 1 sources

        {
            var6_6 = 4096;
            if (var3_3 + var6_6 > wlength) {
                var6_6 = wlength - var3_3;
            }
            System.arraycopy(buf, var3_3, var5_4, 0, var6_6);
            var4_5 = this.N.bulkTransfer(this.Q, var5_4, var6_6, this.X);
            if (var4_5 < 0) {
                return -1;
            }
            var3_3 += var4_5;
lbl16:
            // 2 sources

            ** while (var3_3 < wlength)
        }
lbl17:
        // 1 sources

        return var3_3;
    }

    public int setup(BaudRate R, DataBits D, StopBits S, Parity P, FlowControl F) throws IOException {
        int n = 0;
        int[] nArray = new int[2];
        nArray[0] = 1;
        if (this.N == null) {
            return -1;
        }
        if (FlowControl.XONXOFF == this.aw && !this.ax) {
            return 0;
        }
        n = this.N.controlTransfer(161, 33, 0, 0, this.j, 7, this.Y);
        if (n < 0) {
            return n;
        }
        int n2 = 0;
        switch (PL2303GDriver.a()[R.ordinal()]) {
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 75;
                break;
            }
            case 3: {
                n2 = 150;
                break;
            }
            case 4: {
                n2 = 300;
                break;
            }
            case 5: {
                n2 = 600;
                break;
            }
            case 6: {
                n2 = 1200;
                break;
            }
            case 7: {
                n2 = 1800;
                break;
            }
            case 8: {
                n2 = 2400;
                break;
            }
            case 9: {
                n2 = 4800;
                break;
            }
            case 10: {
                n2 = 9600;
                break;
            }
            case 11: {
                n2 = 14400;
                break;
            }
            case 12: {
                n2 = 19200;
                break;
            }
            case 13: {
                n2 = 38400;
                break;
            }
            case 14: {
                n2 = 57600;
                break;
            }
            case 15: {
                n2 = 115200;
                break;
            }
            case 16: {
                n2 = 230400;
                break;
            }
            case 17: {
                n2 = 460800;
                break;
            }
            case 18: {
                n2 = 614400;
                break;
            }
            case 19: {
                n2 = 921600;
                break;
            }
            case 20: {
                n2 = 1228800;
                break;
            }
            case 21: {
                n2 = 2457600;
                break;
            }
            case 22: {
                n2 = 3000000;
                break;
            }
            case 23: {
                n2 = 6000000;
                break;
            }
            case 24: {
                n2 = 12000000;
                break;
            }
            default: {
                return -2;
            }
        }
        if (n2 > 1228800 && this.aj == 0) {
            return -2;
        }
        if (this.aa != null) {
            this.a(R);
        }
        this.j[0] = (byte)(n2 & 0xFF);
        this.j[1] = (byte)(n2 >> 8 & 0xFF);
        this.j[2] = (byte)(n2 >> 16 & 0xFF);
        this.j[3] = (byte)(n2 >> 24 & 0xFF);
        switch (PL2303GDriver.b()[S.ordinal()]) {
            case 1: {
                this.j[4] = 0;
                break;
            }
            case 2: {
                this.j[4] = 2;
                break;
            }
            default: {
                return -3;
            }
        }
        switch (PL2303GDriver.c()[P.ordinal()]) {
            case 1: {
                this.j[5] = 0;
                break;
            }
            case 2: {
                this.j[5] = 1;
                break;
            }
            case 3: {
                this.j[5] = 2;
                break;
            }
            default: {
                return -4;
            }
        }
        switch (PL2303GDriver.d()[D.ordinal()]) {
            case 1: {
                this.j[6] = 5;
                break;
            }
            case 2: {
                this.j[6] = 6;
                break;
            }
            case 3: {
                this.j[6] = 7;
                break;
            }
            case 4: {
                this.j[6] = 8;
                break;
            }
            default: {
                return -5;
            }
        }
        n = this.N.controlTransfer(33, 32, 0, 0, this.j, 7, this.Y);
        if (n < 0) {
            return n;
        }
        n = this.N.controlTransfer(33, 35, 0, 0, null, 0, this.Y);
        if (n < 0) {
            return n;
        }
        this.aj = 10;
        nArray = this.e(8);
        if (nArray[0] < 0) {
            return nArray[0];
        }
        switch (PL2303GDriver.e()[F.ordinal()]) {
            case 1: {
                nArray[1] = nArray[1] | 0xC;
                n = this.b(8, nArray[1]);
                if (n >= 0) break;
                return n;
            }
            case 2: {
                nArray[1] = nArray[1] & 0xFFFFFFF3;
                nArray[1] = nArray[1] | 8;
                n = this.b(8, nArray[1]);
                if (n >= 0) break;
                return n;
            }
            case 3: {
                break;
            }
            case 4: {
                nArray[1] = nArray[1] & 0xFFFFFFF3;
                nArray[1] = nArray[1] | 4;
                n = this.b(8, nArray[1]);
                if (n >= 0) break;
                return n;
            }
            case 5: {
                nArray[1] = nArray[1] & 0xFFFFFFF3;
                n = this.b(8, nArray[1]);
                if (n >= 0) break;
                return n;
            }
            case 6: {
                nArray[1] = nArray[1] & 0xFFFFFFEF;
                n = this.b(8, nArray[1]);
                if (n >= 0) break;
                return n;
            }
            default: {
                return -6;
            }
        }
        this.aw = F;
        if (this.af) {
            n = this.a(0, 49);
            if (n < 0) {
                return n;
            }
            n = this.a(1, 8);
            if (n < 0) {
                return n;
            }
        }
        return 0;
    }

    public int setDTR(boolean state) {
        int n;
        if (state && (this.F & 1) != 1) {
            ++this.F;
        }
        if (!state && (this.F & 1) == 1) {
            --this.F;
        }
        if ((n = this.N.controlTransfer(33, 34, this.F, 0, null, 0, this.Y)) < 0) {
            return n;
        }
        return 0;
    }

    public int setRTS(boolean state) {
        int n;
        if (state && (this.F & 2) != 2) {
            this.F += 2;
        }
        if (!state && (this.F & 2) == 2) {
            this.F -= 2;
        }
        if ((n = this.N.controlTransfer(33, 34, this.F, 0, null, 0, this.Y)) < 0) {
            return n;
        }
        return 0;
    }

    private int a(UsbDeviceConnection usbDeviceConnection) {
        int n = 0;
        int[] nArray = new int[2];
        nArray[0] = 0;
        if (this.au) {
            this.aj = 4;
        } else {
            if (!this.l() && (n = this.m()) < 0) {
                return n;
            }
            if (usbDeviceConnection.getRawDescriptors()[13] == 4) {
                this.aj = 4;
            }
            if ((n = this.j()) < 0) {
                return n;
            }
            if (this.aK && (n = this.k()) < 0) {
                return n;
            }
            if (usbDeviceConnection.getRawDescriptors()[13] == 5 && (n = this.i()) < 0) {
                return n;
            }
        }
        if (this.aj != 4 && this.aj != 6) {
            return -1;
        }
        int n2 = 128;
        while (n2 <= 130) {
            nArray = this.b(n2);
            if (nArray[0] < 0) {
                return nArray[0];
            }
            ++n2;
        }
        try {
            n = this.setup(BaudRate.B9600, DataBits.D8, StopBits.S1, Parity.NONE, FlowControl.OFF);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (nArray[0] < 0) {
            return n;
        }
        return 0;
    }

    private int i() {
        int[] nArray = new int[2];
        int n = 148;
        nArray = this.b(148);
        if (nArray[0] < 0) {
            return nArray[0];
        }
        this.aj = (nArray[1] & n) == n ? 6 : 2;
        return 0;
    }

    private int j() {
        int[] nArray = new int[2];
        int n = 255;
        int[] nArray2 = new int[2];
        nArray = this.b(129);
        if (nArray[0] < 0) {
            return nArray[0];
        }
        int n2 = nArray[1];
        nArray[0] = this.a(1, n);
        if (nArray[0] < 0) {
            return nArray[0];
        }
        nArray = this.b(129);
        if (nArray[0] < 0) {
            return nArray[0];
        }
        if ((nArray[1] & 0xF) == 15) {
            this.aj = 4;
            nArray = this.c(250);
            if (nArray[0] < 0) {
                return nArray[0];
            }
            nArray2[0] = nArray[1];
            nArray = this.c(251);
            if (nArray[0] < 0) {
                return nArray[0];
            }
            nArray2[1] = nArray[1];
            if (!(nArray2[0] == 1 && nArray2[1] == 4 || nArray2[0] == 2 && nArray2[1] == 4 || nArray2[0] == 3 && nArray2[1] == 4 || nArray2[0] != 1 || nArray2[1] != 3)) {
                this.aj = 2;
            }
        } else {
            this.aj = 2;
        }
        nArray[0] = this.a(1, n2);
        if (nArray[0] < 0) {
            return nArray[0];
        }
        return 0;
    }

    private String a(int n) {
        char[] cArray = new char[]{Character.forDigit(n >> 4 & 0xF, 16), Character.forDigit(n & 0xF, 16)};
        String string = new String(cArray);
        return string;
    }

    private static String b(byte[] byArray, int n) {
        StringBuffer stringBuffer = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
            messageDigest.reset();
            byte[] byArray2 = messageDigest.digest(byArray);
            stringBuffer = new StringBuffer();
            byte[] byArray3 = byArray2;
            int n2 = byArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                byte by = byArray3[n3];
                stringBuffer.append(String.format("%02X", by));
                ++n3;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    private int k() {
        int n = 9;
        int[] nArray = new int[2];
        nArray = this.c(n);
        if (nArray[0] < 0) {
            return nArray[0];
        }
        if ((nArray[1] & 8) == 8) {
            nArray[0] = this.a(0, 49);
            if (nArray[0] < 0) {
                return nArray[0];
            }
            nArray[0] = this.a(1, 8);
            if (nArray[0] < 0) {
                return nArray[0];
            }
            this.af = true;
        }
        return nArray[0];
    }

    public int PL2303G_GPIO_B_CNT_ENABLE(boolean Enable) {
        int[] nArray = new int[2];
        int n = Enable ? 255 : 0;
        if (this.N == null) {
            return -1;
        }
        nArray[0] = this.a(5, n);
        if (nArray[0] < 0) {
            return nArray[0];
        }
        return 0;
    }

    public int PL2303G_Enable_GPIO_B(int GPIO_Num, boolean Enable) {
        int[] nArray = new int[2];
        boolean bl = false;
        if (this.N == null) {
            return -1;
        }
        switch (GPIO_Num) {
            case 0: {
                if (Enable) {
                    this.aM |= 1;
                    break;
                }
                this.aM &= 0xFFFFFFFE;
                break;
            }
            case 1: {
                if (Enable) {
                    this.aM |= 2;
                    break;
                }
                this.aM &= 0xFFFFFFFD;
                break;
            }
            case 2: {
                if (Enable) {
                    this.aM |= 4;
                    break;
                }
                this.aM &= 0xFFFFFFFB;
                break;
            }
            case 3: {
                if (Enable) {
                    this.aM |= 8;
                    break;
                }
                this.aM &= 0xFFFFFFF7;
                break;
            }
            case 4: {
                if (Enable) {
                    this.aM |= 0x10;
                    break;
                }
                this.aM &= 0xFFFFFFEF;
                break;
            }
            case 5: {
                if (Enable) {
                    this.aM |= 0x20;
                    break;
                }
                this.aM &= 0xFFFFFFDF;
                break;
            }
            case 6: {
                if (Enable) {
                    this.aM |= 0x40;
                    break;
                }
                this.aM &= 0xFFFFFFBF;
                break;
            }
            case 7: {
                if (Enable) {
                    this.aM |= 0x80;
                    break;
                }
                this.aM &= 0xFFFFFF7F;
                break;
            }
            default: {
                return -1;
            }
        }
        nArray[0] = this.a(3, this.aM);
        if (nArray[0] < 0) {
            return nArray[0];
        }
        return 0;
    }

    public int PL2303G_Set_GPIO_Value_B(int GPIO_Num, int val) {
        int[] nArray = new int[2];
        boolean bl = false;
        if (this.N == null) {
            return -1;
        }
        switch (GPIO_Num) {
            case 0: {
                if (val == 1) {
                    this.aN |= 1;
                    break;
                }
                this.aN &= 0xFFFFFFFE;
                break;
            }
            case 1: {
                if (val == 1) {
                    this.aN |= 2;
                    break;
                }
                this.aN &= 0xFFFFFFFD;
                break;
            }
            case 2: {
                if (val == 1) {
                    this.aN |= 4;
                    break;
                }
                this.aN &= 0xFFFFFFFB;
                break;
            }
            case 3: {
                if (val == 1) {
                    this.aN |= 8;
                    break;
                }
                this.aN &= 0xFFFFFFF7;
                break;
            }
            case 4: {
                if (val == 1) {
                    this.aN |= 0x10;
                    break;
                }
                this.aN &= 0xFFFFFFEF;
                break;
            }
            case 5: {
                if (val == 1) {
                    this.aN |= 0x20;
                    break;
                }
                this.aN &= 0xFFFFFFDF;
                break;
            }
            case 6: {
                if (val == 1) {
                    this.aN |= 0x40;
                    break;
                }
                this.aN &= 0xFFFFFFBF;
                break;
            }
            case 7: {
                if (val == 1) {
                    this.aN |= 0x80;
                    break;
                }
                this.aN &= 0xFFFFFF7F;
                break;
            }
            default: {
                return -1;
            }
        }
        nArray[0] = this.a(1, this.aN);
        if (nArray[0] < 0) {
            return nArray[0];
        }
        return 0;
    }

    public int[] PL2303G_Get_GPIO_Value_B(int GPIO_Num) {
        int[] nArray = new int[2];
        if (this.N == null) {
            nArray[0] = -1;
            return nArray;
        }
        nArray = this.b(1);
        if (nArray[0] < 0) {
            return nArray;
        }
        switch (GPIO_Num) {
            case 0: {
                if ((nArray[1] & 1) == 1) {
                    nArray[1] = 1;
                    break;
                }
                nArray[1] = 0;
                break;
            }
            case 1: {
                if ((nArray[1] & 2) == 2) {
                    nArray[1] = 1;
                    break;
                }
                nArray[1] = 0;
                break;
            }
            case 2: {
                if ((nArray[1] & 4) == 4) {
                    nArray[1] = 1;
                    break;
                }
                nArray[1] = 0;
                break;
            }
            case 3: {
                if ((nArray[1] & 8) == 8) {
                    nArray[1] = 1;
                    break;
                }
                nArray[1] = 0;
                break;
            }
            case 4: {
                if ((nArray[1] & 0x10) == 16) {
                    nArray[1] = 1;
                    break;
                }
                nArray[1] = 0;
                break;
            }
            case 5: {
                if ((nArray[1] & 0x20) == 32) {
                    nArray[1] = 1;
                    break;
                }
                nArray[1] = 0;
                break;
            }
            case 6: {
                if ((nArray[1] & 0x40) == 64) {
                    nArray[1] = 1;
                    break;
                }
                nArray[1] = 0;
                break;
            }
            case 7: {
                if ((nArray[1] & 0x80) == 128) {
                    nArray[1] = 1;
                    break;
                }
                nArray[1] = 0;
                break;
            }
            default: {
                nArray[0] = -1;
                return nArray;
            }
        }
        return nArray;
    }

    private int a(int n, int n2) {
        int n3 = 0;
        if (this.N == null) {
            return -1;
        }
        n3 = this.N.controlTransfer(64, 128, n, n2, null, 0, this.Y);
        if (n3 < 0) {
            return n3;
        }
        return n3;
    }

    private int[] b(int n) {
        int[] nArray = new int[2];
        byte[] byArray = new byte[1];
        nArray[0] = 0;
        if (this.N == null) {
            nArray[0] = -1;
            return nArray;
        }
        nArray[0] = this.N.controlTransfer(192, 129, n, 0, byArray, 1, this.Y);
        if (nArray[0] < 0) {
            return nArray;
        }
        nArray[1] = byArray[0];
        return nArray;
    }

    private int[] c(int n) {
        int[] nArray = new int[2];
        nArray[0] = 0;
        nArray = this.b(132);
        if (nArray[0] < 0) {
            return nArray;
        }
        nArray[0] = this.a(4, n);
        if (nArray[0] < 0) {
            return nArray;
        }
        nArray = this.b(132);
        if (nArray[0] < 0) {
            return nArray;
        }
        nArray = this.b(131);
        if (nArray[0] < 0) {
            return nArray;
        }
        return nArray;
    }

    private boolean l() {
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        int n = 0;
        while (n < 2) {
            nArray = this.c(n);
            if (nArray[0] < 0) {
                return this.aK;
            }
            nArray2[n] = nArray[1];
            ++n;
        }
        if (nArray2[0] == 123 && nArray2[1] == 6) {
            this.aK = true;
        }
        return this.aK;
    }

    private int m() {
        int n = 0;
        this.aj = 10;
        n = this.b(8, 254);
        if (n < 0) {
            // empty if block
        }
        return n;
    }

    private int d(int n) {
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[2];
        int n2 = 0;
        int n3 = 0;
        if (this.N == null) {
            return -1;
        }
        byArray2[0] = (byte)(n & 0xFF);
        byArray2[1] = (byte)(n >> 8 & 0xFF);
        n2 = this.N.controlTransfer(161, 32, 0, 0, byArray2, 2, this.X);
        if (n2 < 0) {
            return n2;
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        n2 = this.N.bulkTransfer(this.R, byArray, byArray.length, this.W);
        if (n2 < 0) {
            return 0;
        }
        n3 = byArray[1] << 8 | byArray[0];
        return n3;
    }

    private int[] n() {
        int[] nArray = new int[2];
        int n = 135;
        nArray[0] = 0;
        nArray = this.b(n);
        if (nArray[0] < 0) {
            return nArray;
        }
        return nArray;
    }

    public int[] PL2303G_GetCommModemStatus() {
        int[] nArray = new int[2];
        int n = 0;
        nArray = this.n();
        if (nArray[0] < 0) {
            return nArray;
        }
        n = (nArray[1] & 1) == 1 ? (n &= 0xFFFFFFF7) : (n |= 8);
        n = (nArray[1] & 2) == 2 ? (n &= 0xFFFFFFFE) : (n |= 1);
        n = (nArray[1] & 4) == 4 ? (n &= 0xFFFFFFFD) : (n |= 2);
        n = (nArray[1] & 8) == 8 ? (n &= 0xFFFFFF7F) : (n |= 0x80);
        nArray[1] = n;
        return nArray;
    }

    public void PL2303LibGetVersion(byte[] byVersion) {
        int n = 0;
        n = byVersion.length < i.length() ? byVersion.length : i.length();
        char[] cArray = i.toCharArray();
        int n2 = 0;
        while (n2 < n) {
            byVersion[n2] = (byte)cArray[n2];
            ++n2;
        }
    }

    public boolean PL2303USBFeatureSupported() {
        boolean bl = this.d.getPackageManager().hasSystemFeature("android.hardware.usb.host");
        return bl;
    }

    public String PL2303Device_GetSerialNumber() {
        if (this.isConnected()) {
            return this.N.getSerial();
        }
        return null;
    }

    public boolean PL2303Device_IsHasPermission() {
        return this.at;
    }

    public boolean PL2303Device_IsSupportChip() {
        boolean bl = false;
        if (this.aj == 10) {
            bl = true;
        }
        return bl;
    }

    public boolean PL2303Device_SetCommTimeouts(int TimeoutConstant) {
        if (TimeoutConstant < 0) {
            return false;
        }
        this.W = TimeoutConstant;
        this.X = TimeoutConstant;
        return true;
    }

    public boolean PL2303Device_GetCommTimeouts(int TimeoutConstant) {
        TimeoutConstant = this.X;
        return true;
    }

    private static void a(Object object) {
    }

    private int b(int n, int n2) {
        int n3 = 0;
        if (this.aL) {
            return n3;
        }
        if (this.N == null) {
            return -1;
        }
        n3 = this.N.controlTransfer(64, 128, n, n2, null, 0, this.Y);
        if (n3 < 0) {
            return n3;
        }
        return n3;
    }

    private int[] e(int n) {
        int[] nArray = new int[2];
        byte[] byArray = new byte[1];
        nArray[0] = 0;
        if (this.aL) {
            return nArray;
        }
        if (this.N == null) {
            nArray[0] = -1;
            return nArray;
        }
        nArray[0] = this.N.controlTransfer(192, 129, n, 0, byArray, 1, this.Y);
        if (nArray[0] < 0) {
            return nArray;
        }
        nArray[1] = byArray[0];
        return nArray;
    }

    private int c(int n, int n2) {
        int n3 = 0;
        if (this.N == null) {
            return -1;
        }
        n3 = this.N.controlTransfer(64, 130, n, n2, null, 0, this.Y);
        if (n3 < 0) {
            return n3;
        }
        return n3;
    }

    private int[] f(int n) {
        int[] nArray = new int[2];
        byte[] byArray = new byte[1];
        nArray[0] = 0;
        if (this.N == null) {
            nArray[0] = -1;
            return nArray;
        }
        nArray[0] = this.N.controlTransfer(192, 131, n, 0, byArray, 1, this.Y);
        if (nArray[0] < 0) {
            return nArray;
        }
        nArray[1] = byArray[0];
        return nArray;
    }

    private int[] o() {
        int[] nArray = new int[2];
        byte[] byArray = new byte[1];
        nArray[0] = 0;
        if (this.N == null) {
            nArray[0] = -1;
            return nArray;
        }
        nArray[0] = this.N.controlTransfer(192, 130, 0, 0, byArray, 1, this.Y);
        if (nArray[0] < 0) {
            return nArray;
        }
        nArray[1] = byArray[0];
        return nArray;
    }

    static /* synthetic */ int a(PL2303GDriver pL2303GDriver, byte[] byArray, int n) {
        return pL2303GDriver.a(byArray, n);
    }

    static /* synthetic */ FlowControl f(PL2303GDriver pL2303GDriver) {
        return pL2303GDriver.aw;
    }

    static /* synthetic */ void b(PL2303GDriver pL2303GDriver, boolean bl) {
        pL2303GDriver.ax = bl;
    }

    static /* synthetic */ int[] a() {
        if (aQ != null) {
            return aQ;
        }
        int[] nArray = new int[BaudRate.values().length];
        try {
            nArray[BaudRate.B0.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B115200.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B1200.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B12000000.ordinal()] = 24;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B1228800.ordinal()] = 20;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B14400.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B150.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B1800.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B19200.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B230400.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B2400.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B2457600.ordinal()] = 21;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B300.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B3000000.ordinal()] = 22;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B38400.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B460800.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B4800.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B57600.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B600.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B6000000.ordinal()] = 23;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B614400.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B75.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B921600.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B9600.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        aQ = nArray;
        return nArray;
    }

    static /* synthetic */ int[] b() {
        if (aR != null) {
            return aR;
        }
        int[] nArray = new int[StopBits.values().length];
        try {
            nArray[StopBits.S1.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StopBits.S2.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        aR = nArray;
        return nArray;
    }

    static /* synthetic */ int[] c() {
        if (aS != null) {
            return aS;
        }
        int[] nArray = new int[Parity.values().length];
        try {
            nArray[Parity.EVEN.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Parity.NONE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Parity.ODD.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        aS = nArray;
        return nArray;
    }

    static /* synthetic */ int[] d() {
        if (aT != null) {
            return aT;
        }
        int[] nArray = new int[DataBits.values().length];
        try {
            nArray[DataBits.D5.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataBits.D6.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataBits.D7.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataBits.D8.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        aT = nArray;
        return nArray;
    }

    static /* synthetic */ int[] e() {
        if (aU != null) {
            return aU;
        }
        int[] nArray = new int[FlowControl.values().length];
        try {
            nArray[FlowControl.DTRDSR.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FlowControl.OFF.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FlowControl.RFRCTS.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FlowControl.RTSCTS.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FlowControl.RTSCTSDTRDSR.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FlowControl.XONXOFF.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        aU = nArray;
        return nArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BaudRate {
        B0,
        B75,
        B150,
        B300,
        B600,
        B1200,
        B1800,
        B2400,
        B4800,
        B9600,
        B14400,
        B19200,
        B38400,
        B57600,
        B115200,
        B230400,
        B460800,
        B614400,
        B921600,
        B1228800,
        B2457600,
        B3000000,
        B6000000,
        B12000000;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataBits {
        D5,
        D6,
        D7,
        D8;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FlowControl {
        OFF,
        RTSCTS,
        RFRCTS,
        DTRDSR,
        RTSCTSDTRDSR,
        XONXOFF;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Parity {
        NONE,
        ODD,
        EVEN;

    }

    class a
    extends Thread {
        private int b;
        private int c;
        private boolean d = true;
        private boolean e = false;
        private AtomicInteger f = new AtomicInteger(500);

        a() {
        }

        public void a() {
            this.c = 0;
            this.b = 0;
            PL2303GDriver.this.Z.clear();
        }

        public void a(int n) {
            this.a();
            this.b(n);
        }

        public void b(int n) {
            this.f.set(n);
        }

        public void b() {
            this.e = true;
            while (this.isAlive()) {
            }
            PL2303GDriver.this.Z.clear();
        }

        private void c(int n) {
            long l;
            if (n == 0) {
                return;
            }
            long l2 = System.currentTimeMillis();
            do {
                l = System.currentTimeMillis();
                Thread.yield();
            } while (l - l2 <= (long)n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            try {
                var1_1 = new byte[4096];
                while (!this.e) {
                    block11: {
                        this.b = PL2303GDriver.a(PL2303GDriver.this, var1_1, var1_1.length);
                        if (this.b <= 0) break block11;
                        var3_5 = PL2303GDriver.ReadQueueLock;
                        synchronized (var3_5) {
                            this.c = PL2303GDriver.e(PL2303GDriver.this).size();
                            if (4096 == this.c) break block11;
                            var4_6 = 0;
                            while (var4_6 < this.b && this.c < 4096) {
                                var2_3 = var1_1[var4_6];
                                if (FlowControl.XONXOFF != PL2303GDriver.f(PL2303GDriver.this)) ** GOTO lbl-1000
                                if (19 == var2_3) {
                                    PL2303GDriver.b(PL2303GDriver.this, false);
                                } else if (17 == var2_3) {
                                    PL2303GDriver.b(PL2303GDriver.this, true);
                                } else lbl-1000:
                                // 2 sources

                                {
                                    this.d = PL2303GDriver.e(PL2303GDriver.this).offer(var2_3);
                                    if (!this.d) break;
                                    this.c = PL2303GDriver.e(PL2303GDriver.this).size();
                                }
                                ++var4_6;
                            }
                        }
                    }
                    var3_4 = this.f.get();
                    this.c(var3_4);
                }
            }
            catch (Exception var1_2) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StopBits {
        S1,
        S2;

    }
}

